********************************************************
*** Figure 6: In and out-of-sample performance of models (ROC curves) ***
********************************************************
clear all 
use "$dataPath\Data"
do "$codePath\Transforming_variables"

regress global_credit_gap pcredit_gdp_gap
predict interak1, res

regress global_hp_gap hp_inc_gap
predict interak2, res

replace global_credit_gap = interak1
replace global_hp_gap = interak2

************************************************
*** Decomposing credit, Column 1 in Table 2 ****
************************************************
set more off
logit crisis4_12 dlogreal_pcredit hcredit_gdp_gap nfecredit_gdp_gap hp_inc_gap gdp_gap i.country_id, robust cluster(period)
predict p_1, p
bysort start_crisis : count if p_1 !=. & year > 2000
bysort start_crisis : count if p_1 !=.
logit crisis4_12 dlogreal_pcredit hcredit_gdp_gap nfecredit_gdp_gap hp_inc_gap gdp_gap i.country_id if year <= 2000 , robust cluster(period)
predict p_2, p
bysort start_crisis : count if p_2 !=. & year > 2000


*******************************************************
*** Including global variables, Column 2 in Table 2 ***
*******************************************************
set more off
logit crisis4_12 dlogreal_pcredit hcredit_gdp_gap nfecredit_gdp_gap hp_inc_gap gdp_gap global_credit_gap global_hp_gap i.country_id, robust cluster(period)
predict p_3, p
bysort start_crisis : count if p_3 !=. & year > 2000

logit crisis4_12 dlogreal_pcredit hcredit_gdp_gap nfecredit_gdp_gap hp_inc_gap gdp_gap global_credit_gap global_hp_gap i.country_id if year <= 2000, robust cluster(period)
predict p_4, p
bysort start_crisis : count if p_4 !=. & year > 2000

****************************************************************************
*** Including exuberance in house prices and credit, Column 3 in Table 2 ***
****************************************************************************
set more off
logit crisis4_12 dlogreal_pcredit hcredit_gdp_gap nfecredit_gdp_gap hp_inc_gap gdp_gap global_credit_gap global_hp_gap i.ind_hp_inc_exu i.ind_credit_gdp_exu i.country_id , robust cluster(period)
predict p_5, p
bysort start_crisis : count if p_5 !=. & year > 2000
logit crisis4_12 dlogreal_pcredit hcredit_gdp_gap nfecredit_gdp_gap hp_inc_gap gdp_gap global_credit_gap global_hp_gap i.ind_hp_inc_exu i.ind_credit_gdp_exu i.country_id if year <= 2000, robust cluster(period)
predict p_6, p
bysort start_crisis : count if p_6 !=. & year > 2000

*******************************************************
*** Including banking variables, Column 4 in Table 2***
*******************************************************
set more off
logit crisis4_12 dlogreal_pcredit hcredit_gdp_gap nfecredit_gdp_gap hp_inc_gap gdp_gap global_credit_gap global_hp_gap i.ind_hp_inc_exu i.ind_credit_gdp_exu wholesale_gap equity_assets i.country_id, robust cluster(period)
predict p_7, p
bysort start_crisis : count if p_7 !=. & year > 2000
logit crisis4_12 dlogreal_pcredit hcredit_gdp_gap nfecredit_gdp_gap hp_inc_gap gdp_gap global_credit_gap global_hp_gap i.ind_hp_inc_exu i.ind_credit_gdp_exu wholesale_gap equity_assets i.country_id if year <= 2000, robust cluster(period)
predict p_8, p
bysort start_crisis : count if p_8 !=. & year > 2000
********************************************************************************

* Keeping only the forecast horizon 

keep if year >=1999
keep country country_id period quarter year start_crisis* crisis* bankingcrisis p_* pcredit_gdp_gap
keep if pcredit_gdp_gap != .
keep if year < 2013
cd "$outputFigures"
* Panel a) 
preserve 
keep if p_1 != . & p_2 != . & pcredit_gdp_gap != .
roccomp crisis4_12 p_1 pcredit_gdp_gap
roccomp crisis4_12 p_2 pcredit_gdp_gap
roccurve crisis4_12 p_1 p_2 pcredit_gdp_gap, title("") lw(medthick) ///
legend(title("") order(1 "In-Sample, AUROC = 0.8858***" 2 "Out-of-sample, AUROC = 0.7124**" 3 "Credit to GDP gap, AUROC = 0.6813") ring(0) rows(3)  pos(5) region(fcolor(none) lcolor(none))) ///
	  xlabel(#5, tposition(inside) nogrid) ylabel(#5, tposition(inside))  ///
	  scheme(s1color) xmtick(, tposition(inside)) ymtick(, tposition(inside)) ///
	  xtitle("False Positive Rate", size(4) justification(center) margin(b=0)) ytitle("True Positive Rate (% predicted)", size(4) justification(center) orientation(vertical)) ///
	  xline(0(.2)1,lstyle(grid) lw(.02) lcolor(white)) yline(0(.2)1,lstyle(grid) lw(.02) lcolor(white)) 
graph export Model1_roc.pdf, replace
restore


* Panel b)
preserve
drop if country == "DNK" || country == "GRC" || country == "PRT" 
keep if p_3 != . & p_4 != . & pcredit_gdp_gap != .	  
roccomp crisis4_12 p_3 pcredit_gdp_gap
roccomp crisis4_12 p_4 pcredit_gdp_gap
roccurve crisis4_12 p_3 p_4 pcredit_gdp_gap, title("") lw(medthick) ///
legend(title("") order(1 "In-Sample, AUROC = 0.9562***" 2 "Out-of-sample, AUROC = 0.6955" 3 "Credit to GDP gap, AUROC = 0.6822") ring(0) rows(3)  pos(5) region(fcolor(none) lcolor(none))) ///
	  xlabel(#5, tposition(inside) nogrid) ylabel(#5, tposition(inside))  ///
	  scheme(s1color) xmtick(, tposition(inside)) ymtick(, tposition(inside)) ///
	  xtitle("False Positive Rate", size(4) justification(center) margin(b=0)) ytitle("True Positive Rate (% predicted)", size(4) justification(center) orientation(vertical)) ///
	  xline(0(.2)1,lstyle(grid) lw(.02) lcolor(white)) yline(0(.2)1,lstyle(grid) lw(.02) lcolor(white))
graph export Model2_roc.pdf, replace
restore



* Panel c)
	  
set more off
drop if country == "DNK" || country == "GRC" || country == "PRT" || country == "AUT" || country == "CAN" 
	  preserve
keep if p_5 != . & p_6 != . & pcredit_gdp_gap != .	  
roccomp crisis4_12 p_5 pcredit_gdp_gap
roccomp crisis4_12 p_6 pcredit_gdp_gap
roccurve crisis4_12 p_5 p_6 pcredit_gdp_gap, title("") lw(medthick) ///
legend(title("") order(1 "In-Sample, AUROC = 0.9679***" 2 "Out-of-sample, AUROC = 0.7307" 3 "Credit to GDP gap, AUROC = 7223") ring(0) rows(3)  pos(5) region(fcolor(none) lcolor(none))) ///
	  xlabel(#5, tposition(inside) nogrid) ylabel(#5, tposition(inside))  ///
	  scheme(s1color) xmtick(, tposition(inside)) ymtick(, tposition(inside)) ///
	  xtitle("False Positive Rate", size(4) justification(center) margin(b=0)) ytitle("True Positive Rate (% predicted)", size(4) justification(center) orientation(vertical)) ///
	  xline(0(.2)1,lstyle(grid) lw(.02) lcolor(white)) yline(0(.2)1,lstyle(grid) lw(.02) lcolor(white))	  
graph export Model3_roc.pdf, replace
restore	 

* Panel d) 
preserve
drop if country == "DNK" || country == "GRC" || country == "PRT" || country == "AUT" || country == "CAN" || country == "GBR" || country == "AUS"
keep if p_7 != . & p_8 != . & pcredit_gdp_gap != .	 
roccomp crisis4_12 p_7 pcredit_gdp_gap
roccomp crisis4_12 p_8 pcredit_gdp_gap
roccurve crisis4_12 p_7 p_8 pcredit_gdp_gap, title("") lw(medthick) ///
legend(title("") order(1 "In-Sample, AUROC = 0.9328***" 2 "Out-of-sample, AUROC = 0.6267" 3 "Credit to GDP gap, AUROC = 0.6776") ring(0) rows(3)  pos(5) region(fcolor(none) lcolor(none))) ///
	  xlabel(#5, tposition(inside) nogrid) ylabel(#5, tposition(inside))  ///
	  scheme(s1color) xmtick(, tposition(inside)) ymtick(, tposition(inside)) ///
	  xtitle("False Positive Rate", size(4) justification(center) margin(b=0)) ytitle("True Positive Rate (% predicted)", size(4) justification(center) orientation(vertical)) ///
	  xline(0(.2)1,lstyle(grid) lw(.02) lcolor(white)) yline(0(.2)1,lstyle(grid) lw(.02) lcolor(white))
graph export Model4_roc.pdf, replace
restore
